
{*******************************************************}
{                                                       }
{       Borland Delphi Visual Component Library         }
{                                                       }
{ Copyright (c) 2004-2005 Borland Software Corporation  }
{                                                       }
{*******************************************************}

unit DeploymentAPI;

interface

uses SysUtils, Classes, ToolsAPI;

type

  // IDE Service
  IOTADeploymentService = interface
    ['{658EBC6E-E96F-45FA-934B-505D158852C7}']
           
  end;

  // Project module interface.  Projects that support deployment may implement.

  IDeployAssemblyReferences = interface;
  
  IDeployableProject = interface
  ['{F775F090-1966-4C65-B778-DF4CD2F7F9E6}']
    function GetHasAssemblyReferences: Boolean;
    function GetAssemblyReferences: IDeployAssemblyReferences;
    property HasAssemblyReferences: Boolean read GetHasAssemblyReferences;
    property AssemblyReferences: IDeployAssemblyReferences read GetAssemblyReferences;
  end;

  IDeployAssemblyReferences = interface
  ['{68E7820D-5249-4E86-9024-E97A6BDC4176}']
    procedure Refresh;
    function GetCount: Integer;
    function GetFileName(I: Integer): string;
    property Count: Integer read GetCount;
    property FileNames[I: Integer]: string read GetFileName;
  end;

implementation


end.
